/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.rental.service;

import itx.erp.customer.service.CustomerService;
import itx.erp.sales.model.Article;
import itx.erp.sales.model.Offer;
import itx.erp.sales.model.OfferLine;
import itx.erp.sales.model.Vat;
import itx.erp.sales.rental.model.RentalContract;
import itx.erp.sales.rental.model.RentalContractLine;
import itx.erp.sales.rental.model.response.RentalContractLineResponse;
import itx.erp.sales.rental.model.response.RentalContractResponse;
import itx.erp.sales.service.ArticleService;
import itx.erp.sales.service.OfferService;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.model.BaseStringMap;
import jtbcore.service.ServiceBase;
import jtbcore.util.DateUtil;
import jtbcore.util.MapUtil;
import jtbcore.util.StringUtil;

public class RentalService
extends ServiceBase {
    protected CustomerService customerService;
    protected ArticleService articleService;
    protected OfferService offerService;

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public ArticleService getArticleService() {
        return this.articleService;
    }

    public void setArticleService(ArticleService articleService) {
        this.articleService = articleService;
    }

    public OfferService getOfferService() {
        return this.offerService;
    }

    public void setOfferService(OfferService offerService) {
        this.offerService = offerService;
    }

    public QueryResult<Article> searchArticle(Map<String, Object> opts) throws SQLException, JTBException {
        QueryBuilder b = new QueryBuilder(this.getConnection());
        b.addSelectField("article_id");
        b.addSelectField("short_description");
        b.addSelectField("rentable");
        b.addSelectField("vat_id");
        b.addSelectField("price_excl_vat");
        b.addSelectField("price_incl_vat");
        b.setTable("sales__article");
        if (opts.containsKey("q") && StringUtil.notEmpty((String)opts.get("q"))) {
            String q = (String)opts.get("q");
            b.addWhere("short_description like ?", "%" + q + "%");
        }
        if (MapUtil.boolValue(opts, "occupation")) {
            b.addWhere("sales__article.rentable = true", new Object[0]);
        }
        b.addWhere("sales__article.active = true", new Object[0]);
        b.setRawOrderBy("short_description");
        ResultSet rs = b.queryResultSet();
        QueryResult qr = QueryResult.build(Article.class, opts, rs);
        rs.close();
        if (MapUtil.boolValue(opts, "occupation")) {
            b.addWhere("sales__article.rentable = true", new Object[0]);
            Date start = DateUtil.string2date((String)opts.get("startOccupation"));
            Date end = DateUtil.string2date((String)opts.get("endOccupation"));
            this.enrichOccupation(qr.getObjects(), start, end);
        }
        return qr;
    }

    public void enrichOccupation(List<Article> articles, Date start, Date end) throws SQLException, JTBException {
        String sql = "select * from rental__rental_contract_line where article_id = ?  AND date(start_time) <= ?  AND (end_time is null or date(end_time) >= ?) ";
        int x = 0;
        while (x < articles.size()) {
            Article a = articles.get(x);
            String strStart = DateUtil.date2string(start);
            String strEnd = DateUtil.date2string(end);
            List lines = this.queryToList(RentalContractLine.class, sql, a.getArticleId(), strEnd, strStart);
            a.setRentalContractLines(lines);
            ++x;
        }
    }

    public RentalContract readContract(Integer rc_id) throws SQLException, JTBException {
        RentalContract rc = (RentalContract)this.queryToObject(RentalContract.class, "select * from rental__rental_contract where rental_contract_id = ?", rc_id);
        List lines = this.queryToList(RentalContractLine.class, "select * from rental__rental_contract_line where rental_contract_id = ? order by sort", rc.getRentalContractId());
        rc.setLines(lines);
        return rc;
    }

    public QueryResult<RentalContractResponse> searchContract(Map<String, Object> opts) throws SQLException, JTBException {
        QueryBuilder b = new QueryBuilder(this.getConnection());
        b.addSelectField("rental__rental_contract", "rental_contract_id");
        b.addSelectField("rental__rental_contract_line", "start_time");
        b.addSelectField("rental__rental_contract_line", "end_time");
        b.addFunctionField("count(*)", "line_count");
        b.addFunctionField("max(rental_contract_line_id)", "rental_contract_line_id");
        b.setTable("rental__rental_contract");
        b.addLeftJoin("customer__customer", "rental__rental_contract.customer_id = customer__customer.customer_id");
        b.addLeftJoin("rental__rental_contract_line", "rental__rental_contract_line.rental_contract_id = rental__rental_contract.rental_contract_id");
        b.addWhere("line_type = 'rental'", new Object[0]);
        b.setGroupBy("rental__rental_contract.rental_contract_id, strftime('%Y-%m-%d %H:%M', rental__rental_contract_line.start_time), strftime('%Y-%m-%d %H:%M', rental__rental_contract_line.end_time)");
        b.setRawOrderBy("rental__rental_contract.edited desc");
        if (opts.containsKey("q") && StringUtil.notEmpty((String)opts.get("q"))) {
            String q = (String)opts.get("q");
            b.addWhere("customer__customer.customer_name like ?", "%" + q + "%");
        }
        ResultSet rs = b.queryResultSet();
        Integer start = 0;
        Integer pageSize = 15;
        if (opts.containsKey("pageSize") && opts.get("pageSize") instanceof Integer) {
            pageSize = (Integer)opts.get("pageSize");
        }
        if (opts.containsKey("limit") && opts.get("limit") instanceof Integer) {
            pageSize = (Integer)opts.get("limit");
        }
        RentalService.moveTo(rs, start);
        ArrayList<RentalContractResponse> contracts = new ArrayList<RentalContractResponse>();
        int x = 0;
        while (x < pageSize && rs.next()) {
            Integer rc_id = rs.getInt("rental_contract_id");
            RentalContract rc = this.readContract(rc_id);
            RentalContractResponse i = new RentalContractResponse();
            if (rc.getCustomerId() != null) {
                i.customerName = (String)this.queryValue(String.class, "select customer_name from customer__customer where customer_id = ?", rc.getCustomerId());
            }
            i.rentalContractId = rc.getRentalContractId();
            i.description = rc.getDescription();
            if (rs.getObject("start_time") != null) {
                i.startTime = rs.getDate("start_time");
            }
            if (rs.getObject("end_time") != null) {
                i.endTime = rs.getDate("end_time");
            }
            i.lineCount = rs.getInt("line_count");
            contracts.add(i);
            ++x;
        }
        Integer rowCount = rs.getRow();
        QueryResult<RentalContractResponse> qr = new QueryResult<RentalContractResponse>();
        qr.setObjects(contracts);
        qr.setStart(start);
        qr.setPageSize(pageSize);
        qr.setRowCount(rowCount);
        rs.close();
        return qr;
    }

    public void save(RentalContract contract) throws IOException, SQLException {
        Integer rcl_id;
        Integer rc_id = super.getConnection().save("rental__rental_contract", "rental_contract_id", contract);
        List recs = super.getConnection().queryList("select rental_contract_line_id from rental__rental_contract_line where rental_contract_id = ?", rc_id);
        ArrayList<Integer> savedLineIds = new ArrayList<Integer>();
        List<RentalContractLine> lines = contract.getLines();
        int x = 0;
        while (x < lines.size()) {
            RentalContractLine l = lines.get(x);
            l.setRentalContractId(rc_id);
            l.setSort(x);
            rcl_id = super.getConnection().save("rental__rental_contract_line", "rental_contract_line_id", l);
            l.setRentalContractLineId(rcl_id);
            savedLineIds.add(rcl_id);
            ++x;
        }
        for (BaseStringMap rec : recs) {
            rcl_id = rec.getPropertyInt("rental_contract_line_id");
            if (savedLineIds.contains(rcl_id)) continue;
            super.getConnection().query("delete from rental__rental_contract_line where rental_contract_line_id = ?", rcl_id);
        }
    }

    public Integer createOffer(RentalContract contract) throws IOException, SQLException, JTBException {
        ArrayList<String> strRentals = new ArrayList<String>();
        for (RentalContractLine l : contract.getLines()) {
            if (!"rental".equals(l.getLineType())) continue;
            String desc = null;
            desc = l.getBaseStringMap().hasProperty("originalDescription") ? l.getBaseStringMap().getProperty("originalDescription") : l.getDescription();
            if (desc == null || strRentals.indexOf(desc) != -1) continue;
            strRentals.add(desc);
        }
        Offer of = new Offer();
        of.setCustomerId(contract.getCustomerId());
        of.setSubject(StringUtil.join(" & ", strRentals));
        of.setOfferDate(new Date());
        of.setOfferStatus("open");
        of.setLines(new ArrayList<OfferLine>());
        ArrayList olines = new ArrayList();
        for (RentalContractLine rcl : contract.getLines()) {
            OfferLine ol = new OfferLine();
            if ("price".equals(rcl.getLineType())) {
                ol.setLineType("price");
            } else {
                ol.setLineType("article");
            }
            ol.setArticleId(rcl.getArticleId());
            ol.setShortDescription(rcl.getDescription());
            ol.setAmount(rcl.getAmount());
            ol.setPriceExclVat(rcl.getPriceExclVat());
            ol.setPriceInclVat(rcl.getPriceInclVat());
            Vat v = this.articleService.readVat(rcl.getVatId());
            ol.setVatPercentage(v.getPercentage());
            of.getLines().add(ol);
        }
        Integer offerId = this.offerService.saveOffer(of);
        return offerId;
    }

    public List<RentalContractLineResponse> linesByCustomer(Integer customerId) throws SQLException {
        QueryBuilder b = new QueryBuilder(this.getConnection());
        b.addSelectField("rental__rental_contract", "rental_contract_id");
        b.addSelectField("rental__rental_contract", "description", "contract_description");
        b.addSelectField("rental__rental_contract", "active");
        b.addSelectField("rental__rental_contract", "edited");
        b.addSelectField("rental__rental_contract", "created");
        b.addSelectField("rental__rental_contract_line", "rental_contract_line_id");
        b.addSelectField("rental__rental_contract_line", "article_id");
        b.addSelectField("rental__rental_contract_line", "line_type");
        b.addSelectField("rental__rental_contract_line", "rental_type");
        b.addSelectField("rental__rental_contract_line", "description", "line_description");
        b.addSelectField("rental__rental_contract_line", "start_time");
        b.addSelectField("rental__rental_contract_line", "end_time");
        b.addSelectField("rental__rental_contract_line", "renewal_period");
        b.addSelectField("rental__rental_contract_line", "renewal_type");
        b.addSelectField("rental__rental_contract_line", "sort");
        b.addSelectField("rental__rental_contract_line", "price_excl_vat");
        b.addSelectField("rental__rental_contract_line", "price_incl_vat");
        b.addSelectField("sales__article", "article_code");
        b.addSelectField("sales__article", "short_description", "article_description");
        b.addSelectField("sales__vat", "description", "vat_description");
        b.setTable("rental__rental_contract_line");
        b.addLeftJoin("rental__rental_contract", "rental__rental_contract.rental_contract_id = rental__rental_contract_line.rental_contract_id");
        b.addLeftJoin("sales__article", "sales__article.article_id = rental__rental_contract_line.article_id");
        b.addLeftJoin("sales__vat", "sales__vat.vat_id = sales__article.vat_id");
        b.addWhere("rental__rental_contract.customer_id = ?", customerId);
        b.addWhere("rental__rental_contract_line.line_type = 'rental'", new Object[0]);
        ResultSet rs = b.queryResultSet();
        ArrayList<RentalContractLineResponse> list = new ArrayList<RentalContractLineResponse>();
        while (rs.next()) {
            RentalContractLineResponse r = new RentalContractLineResponse();
            r.rentalContractId = rs.getInt("rental_contract_id");
            r.rentalContractLineId = rs.getInt("rental_contract_line_id");
            r.lineType = rs.getString("line_type");
            r.rentalType = rs.getString("rental_type");
            r.articleId = rs.getInt("article_id");
            r.articleCode = rs.getString("article_code");
            r.articleDescription = rs.getString("article_description");
            r.vatDescription = rs.getString("vat_description");
            r.contractDescription = rs.getString("contract_description");
            r.lineDescription = rs.getString("line_description");
            r.active = rs.getBoolean("active");
            r.startTime = rs.getDate("start_time");
            r.endTime = rs.getDate("end_time");
            r.renewalPeriod = rs.getInt("renewal_period");
            r.renewalType = rs.getString("renewal_type");
            r.priceExclVat = rs.getDouble("price_excl_vat");
            r.priceInclVat = rs.getDouble("price_incl_vat");
            r.sort = rs.getInt("sort");
            if (r.sort == null) {
                r.sort = 0;
            }
            list.add(r);
        }
        list.sort((o1, o2) -> {
            if (o1.active.booleanValue() && !o2.active.booleanValue()) {
                return 1;
            }
            if (!o1.active.booleanValue() && o2.active.booleanValue()) {
                return -1;
            }
            int r = o2.rentalContractId - o1.rentalContractId;
            if (r != 0) {
                return r;
            }
            return o1.sort - o2.sort;
        });
        return list;
    }

    public List<RentalContractLine> contractsByArticle(Integer articleId) throws SQLException, JTBException {
        String sql = "select l.*, c.customer_name from rental__rental_contract_line l left join rental__rental_contract rc on (l.rental_contract_id = rc.rental_contract_id) left join customer__customer c on (rc.customer_id = c.customer_id) where l.article_id = ? order by l.start_time";
        List lines = this.queryToList(RentalContractLine.class, sql, articleId);
        return lines;
    }

    public List<RentalContractLine> occupationByPeriod(Integer articleId, Date startDate, Date endDate) throws SQLException, JTBException {
        Article art = this.getArticleService().readArticle(articleId);
        List lines = this.queryToList(RentalContractLine.class, "select * from rental__rental_contract_line where  (date(start_time) <= date(?) or start_time is null )    AND  (date(end_time) >= date(?) or end_time is null)     AND article_id = ? ", endDate, startDate);
        return lines;
    }

    public void deleteContract(Integer rentalContractId) throws SQLException {
        this.connection.query("delete from rental__rental_contract where rental_contract_id = ?", rentalContractId);
        this.connection.query("delete from rental__rental_contract_line where rental_contract_id = ?", rentalContractId);
    }

    public List<RentalContractLine> readLinesWithRenewal() throws SQLException, JTBException {
        String sql = "select * from rental__rental_contract_line l where ifnull(l.renewal_period, 0) > 0 \tand (l.renewal_type = 'week' OR l.renewal_type = 'month')";
        List l = this.queryToList(RentalContractLine.class, sql, new Object[0]);
        return l;
    }

    public void updateEndDate(Integer rentalContractLineId, Date newEndDate) throws SQLException {
        if (newEndDate == null) {
            throw new IllegalArgumentException("Invalid newEndDate");
        }
        this.connection.query("update rental__rental_contract_line set end_time = ? where rental_contract_line_id = ?", newEndDate, rentalContractLineId);
    }

    public boolean checkRenewal(RentalContractLine line) throws SQLException {
        if (line.getEndTime() == null) {
            return false;
        }
        if (line.getRenewalPeriod() == null || line.getRenewalPeriod() <= 0) {
            return false;
        }
        Date renewalDate = line.getRenewalDate();
        if (renewalDate == null) {
            return false;
        }
        Date newEndDate = line.getEndTime();
        int ymdNow = DateUtil.ymdNow();
        int ymdRenewal = DateUtil.date2ymd(renewalDate);
        if (ymdRenewal > ymdNow) {
            return false;
        }
        if ("week".equals(line.getRenewalType())) {
            int ymdNewEnd = DateUtil.date2ymd(newEndDate);
            while (ymdNewEnd < ymdRenewal) {
                newEndDate = DateUtil.nextWeek(newEndDate, line.getRenewalPeriod());
                ymdNewEnd = DateUtil.date2ymd(newEndDate);
            }
            this.updateEndDate(line.getRentalContractLineId(), newEndDate);
            return true;
        }
        if ("month".equals(line.getRenewalType())) {
            int ymdNewEnd = DateUtil.date2ymd(newEndDate);
            while (ymdNewEnd < ymdRenewal) {
                newEndDate = DateUtil.nextMonth(newEndDate, line.getRenewalPeriod());
                ymdNewEnd = DateUtil.date2ymd(newEndDate);
            }
            this.updateEndDate(line.getRentalContractLineId(), newEndDate);
            return true;
        }
        return false;
    }
}

